
  /*
   *  Object %name    : main.c%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser.c#1:csrc:1
   *  \author mottig
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "crysatptest_msg_defs.h"
#include "CRYS_SEP_ATP_Defines.h"
#include "DX_VOS_Mem.h"
#include "CRYS_SEP_ATP_DH_Acceptance.h"

// temp
/*#include "gen_release.h"
#include "sep_hw_defs.h"
#include "cache_defs.h"*/


/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/
extern DxUint8_t   FailureFunctionNameOut[TST_FUNC_STRING_LEN];
/**************** Private function prototypes ****************/

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_DH_PKCS3

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* DH PKCS3 test.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_DH_PKCS3(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;
	DxUint8_t	*SEP_Generator_ptr;
	DxUint16_t	SEP_GeneratorSize;
	DxUint8_t	*SEP_Prime_ptr;
	DxUint16_t	SEP_PrimeSize;
	DxUint16_t	SEP_L;
	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;
	/* max buffer size in bytes */
	DxUint32_t  SEP_MaxPrimeBufferSize = DH_BufferMaxLength;
	DxUint32_t  SEP_MaxGeneratorBufferSize = DH_BufferMaxLength;
	

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_GeneratorSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_GENERATORSIZE_IN_OFFSET];
	SEP_PrimeSize     = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_GENERATORSIZE_IN_OFFSET];
	SEP_L             = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_L_IN_OFFSET];
	SEP_Generator_ptr = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DH_GENERATOR_OFFSET];
	SEP_Prime_ptr     = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DH_PRIME_OFFSET];


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_DH_MSG_LENGTH_IN_WORDS + 
						   SEP_MaxGeneratorBufferSize/4 + SEP_MaxPrimeBufferSize/4;
		
	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_DH_PKCS3(SEP_Generator_ptr,
							   SEP_GeneratorSize,
							   SEP_Prime_ptr,
							   SEP_PrimeSize,
							   SEP_L,
							   FailureFunctionNameOut);
		

	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_DH_ANSI942

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* DH ANSI942 test.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_DH_ANSI942(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;
	DxUint8_t	*SEP_Generator_ptr;
	DxUint16_t	SEP_GeneratorSize;
	DxUint8_t	*SEP_Prime_ptr;
	DxUint16_t	SEP_PrimeSize;
	DxUint8_t	*SEP_Q_ptr;
	DxUint16_t	SEP_QSize;
	DxUint16_t	SEP_SecretDataGenType;
	DxUint16_t  SEP_KeyGetSecretKeyType;
	DxUint16_t	SEP_KeyLenInBits;
	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;
	/* max buffer size in bytes */
	DxUint32_t  SEP_MaxPrimeBufferSize     = DH_BufferMaxLength;
	DxUint32_t  SEP_MaxGeneratorBufferSize = DH_BufferMaxLength;
	DxUint32_t  SEP_MaxQBufferSize         = DH_BufferMaxLength;

	

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_GeneratorSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_GENERATORSIZE_IN_OFFSET];
	SEP_PrimeSize     = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_GENERATORSIZE_IN_OFFSET];
	SEP_QSize         = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_QSIZE_IN_OFFSET];
	SEP_SecretDataGenType = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_SecretDataGenType_IN_OFFSET];
	SEP_KeyGetSecretKeyType = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_KeyGetSecretKeyType_IN_OFFSET];
	SEP_KeyLenInBits = (DxUint16_t)msg[DX_EXT_SEP_HOST_DH_KeyLenInBits_IN_OFFSET];
	SEP_Generator_ptr = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DH_GENERATOR_OFFSET];
	SEP_Prime_ptr     = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DH_PRIME_OFFSET];
	SEP_Q_ptr     = (DxUint8_t*)&msg[DX_EXT_SEP_HOST_DH_Q_OFFSET];


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_DH_MSG_LENGTH_IN_WORDS + 
		SEP_MaxGeneratorBufferSize/4 + SEP_MaxPrimeBufferSize/4 + SEP_MaxQBufferSize/4;

	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_DH_ANSI942(SEP_Generator_ptr,
								SEP_GeneratorSize,
								SEP_Prime_ptr,
								SEP_PrimeSize,
								SEP_Q_ptr,
								SEP_QSize,
								SEP_SecretDataGenType,
								SEP_KeyGetSecretKeyType,
								SEP_KeyLenInBits,
								FailureFunctionNameOut);
	
	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}



